<?php
/*---------------------------------------------------+
| PHP-Fusion 6 Content Management System
+----------------------------------------------------+
| Copyright (c) 2002-2007 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
+----------------------------------------------------+
| Forum - Limiter of Number of Threads
| author: Paul Beuk  2007
| http://www.muscapaul.com/
| email: muscapaul@gmail.com
+----------------------------------------------------*/
require_once "../../maincore.php";
require_once BASEDIR."subheader.php";

if (!checkrights("IP")) fallback(BASEDIR."index.php");

require_once ADMIN."navigation.php";

if (file_exists(INFUSIONS."forum_limit/locale/".$settings['locale'].".php")) {
	include INFUSIONS."forum_limit/locale/".$settings['locale'].".php";
} else { include INFUSIONS."forum_limit/locale/English.php"; }

if (iADMIN AND $step=='delete') {
    $result = dbquery("DELETE FROM ".DB_PREFIX."forum_limit_settings WHERE settings_id='$settings_id'");
    redirect(FUSION_SELF);
}

if (isset($_POST['saveforumsetting'])) {
    $error = '';
    if (!isNum($_POST['forum_no'])) $error = $locale['flim302'];
    if (!isNum($_POST['max_threads'])) $error .= $locale['flim303'];
    if (!isNum($_POST['limit_period'])) $error .= $locale['flim304'];
    if (!isNum($_POST['max_per_user'])) $error .= $locale['flim303'];
    if (!isNum($_POST['user_period'])) $error .= $locale['flim304'];

    if ($error!='') {
        opentable($locale['flim301']);
        echo $error;
        closetable();
        tablebreak();
    }
    else {
        $checkforum = dbquery("SELECT * FROM ".$db_prefix."forum_limit_settings WHERE forum_no='$forum_no'");
        if (dbrows($checkforum)!='') {
            $result = dbquery("UPDATE ".$db_prefix."forum_limit_settings SET forum_no='$forum_no', max_threads='$max_threads', limit_period='$limit_period', max_per_user='$max_per_user', user_period='$user_period' WHERE forum_no='$forum_no'");
            redirect(FUSION_SELF);
        } 
        else {
            if ($settings_id!='') {
                $result = dbquery("UPDATE ".$db_prefix."forum_limit_settings SET forum_no='$forum_no', max_threads='$max_threads', limit_period='$limit_period', max_per_user='$max_per_user', user_period='$user_period' WHERE settings_id='$settings_id'");
                redirect(FUSION_SELF);
            }
            else {
                $result = dbquery("INSERT INTO ".DB_PREFIX."forum_limit_settings VALUES('', '$forum_no', '$max_threads', '$limit_period', '$max_per_user', '$user_period')");
                redirect(FUSION_SELF);
            }
        }
    }
}

if ((iADMIN) AND $step == "edit") {
    $result = dbquery("SELECT * FROM ".DB_PREFIX."forum_limit_settings WHERE settings_id='$settings_id'");
    $data = dbarray($result);
    $forum_no = $data['forum_no'];
    $max_threads = $data['max_threads'];
    $limit_period = $data['limit_period'];
    $max_per_user = $data['max_per_user'];
    $user_period = $data['user_period'];
    $formaction = FUSION_SELF."?step=edit&settings_id=$settings_id";
    opentable($locale['flim101']." - ".$locale['flim203']);
}
else {
    $forum_no = '';
    $max_threads = '';
    $limit_period = '';
    $max_per_user = '';
    $user_period = '';
    $formaction = FUSION_SELF."?step=edit&settings_id=";
    opentable($locale['flim101']." - ".$locale['flim204']);
}

echo "<form name='settingsform' method='post' action='".FUSION_SELF."'>";
echo "<table align='center' cellpadding='0' cellspacing='0' width='100%'>";
echo "<tr><td colspan='2'><input type='hidden' name='settings_id' value='".$settings_id."'></td></tr>\n";
$editlist = ""; 
$result2 = dbquery("SELECT * FROM ".DB_PREFIX."forums ORDER BY forum_name");
if (dbrows($result2) != 0) {
    while ($data2 = dbarray($result2)) {
        if ($step == "edit") $sel = ($data['forum_no'] == $data2['forum_id'] ? " selected" : "");
        $editlist .= "<option value='".$data2['forum_id']."'$sel>".$data2['forum_name']."</option>\n";
    }
}
echo "<tr><td align='right' class='tbl'>".$locale['flim205'].":</td>";
echo "<td class='tbl1'><select name='forum_no' class='textbox' style='width:380px;'>$editlist</select></td></tr>\n"; 
echo "<tr><td align='right' class='tbl'>".$locale['flim206'].":</td>";
echo "<td class='tbl'><input type='text' name='max_threads' value='".$data['max_threads']."' maxlength='5' class='textbox' style='width:40px;'></td></tr>";
echo "<tr><td align='right' class='tbl'>".$locale['flim207'].":</td>";
echo "<td class='tbl'><input type='text' name='limit_period' value='".$data['limit_period']."' maxlength='5' class='textbox' style='width:40px;'></td></tr>";
echo "<tr><td align='right' class='tbl'>".$locale['flim218'].":</td>";
echo "<td class='tbl'><input type='text' name='max_per_user' value='".$data['max_per_user']."' maxlength='5' class='textbox' style='width:40px;'></td></tr>";
echo "<tr><td align='right' class='tbl'>".$locale['flim219'].":</td>";
echo "<td class='tbl'><input type='text' name='user_period' value='".$data['user_period']."' maxlength='5' class='textbox' style='width:40px;'></td></tr>";
echo "<tr><td align='center' colspan='2' class='tbl'><input type='submit' name='saveforumsetting' value='".$locale['flim208']."' class='button'></td></tr>";
echo "</table></form>\n";
closetable();
tablebreak();
opentable($locale['flim202']);
echo "<table align='center' cellpadding='0' cellspacing='0' border='0' width='100%'>";
echo "<tr><td class='tbl1'>".$locale['flim212']."</td>\n";
echo "<td class='tbl1' align='right'>".$locale['flim213']."</td>\n";
echo "<td class='tbl1' align='left'>".$locale['flim214']."</td>\n";
echo "<td class='tbl1' align='right'>".$locale['flim215']."</td>\n";
echo "<td class='tbl1' align='left'>".$locale['flim216']."</td>\n";
echo "<td class='tbl1' colspan='2' align='center'>".$locale['flim217']."</td></tr>\n";
$present= dbquery("SELECT t1.*, t2.* FROM ".DB_PREFIX."forum_limit_settings t1 LEFT JOIN ".DB_PREFIX."forums t2 ON t1.forum_no=t2.forum_id WHERE t1.settings_id!='' ORDER BY t2.forum_name ASC");
while ($presentdata = dbarray($present)) {
    if ($presentdata['forum_name']!='') {
        echo "<tr><td class='tbl1'>".$presentdata['forum_name']."</td>";
    }
    else {
        echo "<tr><td class='tbl1'>".$locale['flim211']."</td>";
    }
    echo "<td class='tbl1' align='center'>".$presentdata['max_threads']."</td>";
    echo "<td class='tbl1' align='center'>".$presentdata['limit_period']."</td>";
    echo "<td class='tbl1' align='center'>".$presentdata['max_per_user']."</td>";
    echo "<td class='tbl1' align='center'>".$presentdata['user_period']."</td>";
    echo "<td class='tbl1' align='center'><a href='".FUSION_SELF."?step=edit&settings_id=".$presentdata['settings_id']."' alt='".$locale['flim209']."'>".$locale['flim209']."<a></td></td>";
    echo "<td class='tbl1' align='center'><a href='".FUSION_SELF."?step=delete&settings_id=".$presentdata['settings_id']."' alt='".$locale['flim210']."'>".$locale['flim210']."<a></td></tr>";
}
echo "</table>";
closetable();
require_once BASEDIR."footer.php";
?>