<?php
/*-------------------------------------------------------+
| PHP-Fusion Content Management System
| Copyright  2002 - 2008 Nick Jones
| http://www.php-fusion.co.uk/
+---------------------------------------------------------+
| original idea: Ronald Iwema (Scor3p)  2002-2005
| further development: muscapaul  2005-2008
| web: http://www.muscapaul.com
| email: muscapaul@gmail.com
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/

include "../../maincore.php";
require_once THEMES."templates/admin_header.php";

//if (!iSUPERADMIN) { die("Access Denied"); }
if (!checkrights("XPF") || !defined("iAUTH") || $_GET['aid'] != iAUTH) { redirect("../index.php"); }

include INFUSIONS."extended_profile/infusion_db.php";

if (file_exists(INFUSIONS."extended_profile/locale/".$settings['locale'].".php")) {
	include_once INFUSIONS."extended_profile/locale/".$settings['locale'].".php";
} else {
	include_once INFUSIONS."extended_profile/locale/English.php";
}

// process
$error = "";

if (isset($_GET['move']) && !empty($_GET['move'])) {
	$name = $_GET['name'];
	$from = $_GET['from'];
	if (!isnum($from)) { redirect(FUSION_SELF); } // SQL Injection
	if ($_GET['move'] == "down") { $to = $from+1; }
	elseif ($_GET['move'] == "up") { $to = $from-1; }
	else { redirect(FUSION_SELF.$aidlink); }
	$result = dbquery("UPDATE ".DB_EXTENDED_PROFILE_PROPS." SET prop_order=$from WHERE prop_order=$to");
	$result = dbquery("UPDATE ".DB_EXTENDED_PROFILE_PROPS." SET prop_order=$to WHERE prop_name='".htmlspecialchars($name) . "'");
	redirect(FUSION_SELF.$aidlink);
}

if (isset($_POST['save_new_prop']) && !empty($_POST['save_new_prop'])) {
	$new_prop_name = strtolower(trim($_POST['prop_name']));
	$new_prop_title = trim($_POST['prop_title']);
	$new_prop_order = tonumber($_POST['prop_order']);

	if (empty($new_prop_name)) { $error .= $locale['xpf_201'] . "<br />"; }
	if (empty($new_prop_title)) { $error .= $locale['xpf_202'] . "<br />"; }
	if (prop_name_exists($new_prop_name)) { $error .= $locale['xpf_203'] . "<br />"; }
	if (!is_name_valid($new_prop_name)) { $error .= $locale['xpf_204'] . "<br />"; }

	if (empty($error)) { // add it
		$result = dbquery("UPDATE ".DB_EXTENDED_PROFILE_PROPS." SET prop_order = prop_order + 1 WHERE prop_order >= $new_prop_order");
		$result = dbquery("INSERT INTO ".DB_EXTENDED_PROFILE_PROPS." (prop_name, prop_title, prop_order) VALUES ('".$new_prop_name."', '".addslashes($new_prop_title)."', '". $new_prop_order ."')");
		$new_prop_name = $new_prop_title = $new_prop_order = "";
		redirect(FUSION_SELF.$aidlink);
	}
}

if (isset($_POST['save_edit_prop']) && !empty($_POST['save_edit_prop'])) {
	$new_prop_name = strtolower(trim($_POST['prop_name']));
	$new_prop_title = trim($_POST['prop_title']);
	$new_prop_order = $_POST['prop_order'];

	if (empty($new_prop_name)) { $error .= $locale['xpf_201'] . "<br />"; }
	if (empty($new_prop_title)) { $error .= $locale['xpf_202'] . "<br />"; }
	if (!is_name_valid($new_prop_name)) $error .= $locale['xpf_204'] . "<br />"; // do this check anyway to prevent ppl from fucking with it..

	if (empty($error)) { // edit it
		$result = dbquery("UPDATE ".DB_EXTENDED_PROFILE_PROPS." SET prop_title = '".addslashes($new_prop_title)."', prop_order = '". $new_prop_order ."' WHERE prop_name = '". $new_prop_name . "'");
		$new_prop_name = $new_prop_title = $new_prop_order = "";
		redirect(FUSION_SELF.$aidlink);
	}
}

if (isset($_POST['del_prop']) && !empty($_POST['del_prop'])) {
	$name = $_POST['prop_name'];
	$result = mysql_query("SELECT prop_order FROM ".DB_EXTENDED_PROFILE_PROPS." WHERE prop_name='".addslashes($name)."'");
	if ($result && mysql_num_rows($result) == 1) {
		$old_prop_order = mysql_result($result, 0, 'prop_order');
		$result = dbquery("DELETE FROM ".DB_EXTENDED_PROFILE_PROPS." WHERE prop_name='".addslashes($name)."'");
		$result = dbquery("UPDATE ".DB_EXTENDED_PROFILE_PROPS." SET prop_order = prop_order - 1 WHERE prop_order >= $old_prop_order");
	}
}

// populate order select
$order_select = "<select name='prop_order' class='textbox'>\n";
$order_select.= "<option value='1'>-- ".$locale['xpf_016']." --</option>\n";

// Current Fields
opentable ($locale['xpf_001']);
echo "<table border='1' width='100%' cellspacing='0' cellpadding='0' class='tbl'>\n";
echo "<tr><td>\n";
$result = dbquery("SELECT * FROM ".DB_EXTENDED_PROFILE_PROPS." ORDER BY prop_order ASC");
if ($result && mysql_num_rows($result) > 0) {
	$total_fields = mysql_num_rows($result);
	echo "<table width='100%' align='left' cellspacing='0' cellpadding='0' class='tbl'>\n";
	while ($obj = mysql_fetch_object($result)) {
		echo "<tr><td>\n";
		echo "<form name='editform".$obj->prop_name."' method='post' action='".FUSION_SELF.$aidlink."' >\n";
		echo "<table border='0' width='100%' align='left'>\n";
		echo "<tr><td width='15%'>".$obj->prop_name."&nbsp;&nbsp;</td>\n";
		echo "<td width='25%'>".htmlspecialchars($obj->prop_title, ENT_QUOTES)."&nbsp;&nbsp;</td>\n";
		echo "<td width='10' align='right'>&nbsp;[&nbsp;".$obj->prop_order."</td>\n";
		echo "<td width='20' valign='middle' align='right'>&nbsp;\n";
		if ($obj->prop_order != 1) {
			echo "<a href='".FUSION_SELF.$aidlink."&amp;move=up&amp;name=".$obj->prop_name."&amp;from=".$obj->prop_order."'>\n";
			echo "<img src='".THEME."images/up.gif' border='0' alt='Up' /></a>\n";
		}
		echo "</td>\n<td width='20' valign='middle' align='left'>&nbsp;\n";
		if ($obj->prop_order != $total_fields) {
			echo "<a href='".FUSION_SELF.$aidlink."&amp;move=down&amp;name=".$obj->prop_name."&amp;from=".$obj->prop_order."'>\n";
			echo "<img src='".THEME."images/down.gif' border='0' alt='Down' /></a>\n";
		}
		echo "</td>\n<td width='10' align='left'>&nbsp;]&nbsp;</td>\n";
		echo "<td><input type='submit' name='edit_prop' value='".$locale['xpf_022']."' class='button' /> \n";
		echo "<input type='submit' name='del_prop' value='".$locale['xpf_023']."' class='button' onClick='return DeleteField();' /> \n";
		echo "<input type='hidden' name='prop_name' value='".$obj->prop_name."' />\n</td></tr>\n";
		echo "</table>\n</form>\n";
		echo "</td></tr>\n";

		if ($obj->prop_order != $total_fields) {
			$order_select.= "<option value='".($obj->prop_order+1)."'>".$locale['xpf_015']." ".$obj->prop_name."</option>\n";
		}
		else {
			$order_select.= "<option value='".($obj->prop_order+1)."' selected>-- ".$locale['xpf_017']." --</option>\n";
		}
	}
	echo "</table>\n";
}
else {
	echo $locale['xpf_002'];
}
echo "</td></tr>\n";
echo "</table>\n";
closetable();

$order_select .= "</select>\n";

if (isset($_POST['edit_prop']) && !empty($_POST['edit_prop'])) {
	opentable ($locale['xpf_021']);
	$result = dbquery("SELECT * FROM ".DB_EXTENDED_PROFILE_PROPS." WHERE prop_name = '".$_POST['prop_name']."'");
	if ($result && mysql_num_rows($result) == 1) {
		$new_prop_name = mysql_result($result, 0, 'prop_name');
		$new_prop_title = mysql_result($result, 0, 'prop_title');
		$new_prop_order = mysql_result($result, 0, 'prop_order');
	}
	$submit = "<input type='submit' name='save_edit_prop' value='".$locale['xpf_021']."' class='button' />\n";
	$name = "<input type='text' name='prop_name' value='$new_prop_name' class='textbox' style='width:250px;' readonly /> (<span class='small'>".$locale['xpf_040'].")</span>\n";
	$order_select = $new_prop_order;
}
else {
	opentable ($locale['xpf_010']);
	$new_prop_name = $new_prop_title = $new_prop_order = "";
	$submit = "<input type='submit' name='save_new_prop' value='".$locale['xpf_020']."' class='button' />";
	$name = "<input type='text' name='prop_name' value='$new_prop_name' class='textbox' style='width:250px;' /> * ".$locale['xpf_012'];

}

if (!empty($error)) {
	echo "<div class=\"quote\">".$locale['xpf_200']."<hr />".$error."</div>";
}
echo "<form name='inputform' method='post' action='".FUSION_SELF.$aidlink."' onSubmit='return ValidateForm(this)'>\n";
echo "<table align='center' cellspacing='0' cellpadding='0'>\n";
echo "<tr><td width='100' class='tbl' align='right'>".$locale['xpf_011'].":</td>\n";
echo "<td class='tbl'>$name</td></tr>\n";
echo "<tr><td valign='top' width='100' class='tbl' align='right'><input type='hidden' name='prop_order' value='$new_prop_order' />".$locale['xpf_013'].":</td>\n";
echo "<td class='tbl'><input type='text' name='prop_title' value='$new_prop_title' class='textbox' style='width:250px;' /></td></tr>\n";
echo "<tr><td class='tbl' align='right'>".$locale['xpf_014'].":</td>\n";
echo "<td class='tbl'>$order_select</td></tr>\n";
echo "<tr><td align='center' colspan='2' class='tbl'><br />$submit</td></tr>\n";
echo "</table>\n</form>\n";

// finally add some JavaScript

echo "<script type='text/javascript'>
function DeleteField() {
	return confirm('".$locale['xpf_030']."');
}
function ValidateForm(frm) {
	if(frm.prop_name.value=='') {
		alert('".$locale['xpf_205']."');
		return false;
	}
	if(frm.prop_title.value=='') {
		alert('".$locale['xpf_206']."');
		return false;
	}
	return true;
}
</script>\n";

closetable();


require_once THEMES."templates/footer.php";

function tonumber ($new_order) { // check input, if valid leave as new order remove leading zero's, else get highest order around
// global $db_prefix;
	if (preg_match("/^(0*)([1-9]{1}[0-9]*)$/", $new_order, $result)) { return $result[2]; }
	$result = dbquery("SELECT MAX(prop_order)+1 AS new_order FROM ".DB_EXTENDED_PROFILE_PROPS."");
	if (!$result || mysql_num_rows($result) == 0 || mysql_result($result, 0, 'new_order') == 0) { return 1; }
	return mysql_result($result, 0, 'new_order');
}

function is_name_valid($new_prop_name) { // names should be alfanumeric, and lowercase, but script should do that
	return preg_match("/^[a-z0-9_]+$/", $new_prop_name);
}

function prop_name_exists($new_prop_name, $old_prop_name = "") { // checks if a name already exists, except when name is the same as the old name
// global $db_prefix;
	// when editing the old name could be unchanged, so the update is allowed, return false
	if ($new_prop_name == $old_prop_name) { return false; }
	// try to find the prop_name
	$result = dbquery("SELECT prop_name FROM ".DB_EXTENDED_PROFILE_PROPS." WHERE prop_name='".addslashes($new_prop_name)."'");
	// if there is no result for any reason it's safer to prevent futher db changed, return true
	if (!$result) { return true; }
	// no records found means the prop_name is not found, return true
	if (mysql_num_rows($result) == 0) { return false; }
	// so there is a record found, return true
	return true;
}
?>