<?php
/*---------------------------------------------------+
| PHP-Fusion 7 Content Management System
| Copyright  2002 - 2009 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Filename: terms_settings.php
| Author: Paul Beuk (muscapaul)
| Terms Infusion (Dictionary/Glossary)
| muscapaul@gmail.com / http://www.muscapaul.com
| Copyright  2008-2009
+----------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+----------------------------------------------------*/

require_once "../../maincore.php";
require_once THEMES."templates/admin_header.php";

include INFUSIONS."terms/infusion_db.php";

if (!checkrights("TER")) { redirect(BASEDIR."index.php"); }

$dsettings = dbarray(dbquery("SELECT * FROM ".DB_TERM_SETTINGS.""));
$type = $dsettings['term_type'];

if (file_exists(INFUSIONS."terms/".$type."locale/".$settings['locale'].".php")) {
	include INFUSIONS."terms/".$type."locale/".$settings['locale'].".php";
} else { include INFUSIONS."terms/".$type."locale/English.php"; }

require_once INFUSIONS."terms/include/functions.php";

if (isset($_POST['list'])) { redirect(INFUSIONS."terms/terms.php"); }
if (isset($_POST['savesettings'])) {
	$result = dbquery("UPDATE ".DB_TERM_SETTINGS." SET
		term_version='".stripinput($_POST['term_version'])."',
		term_org='".stripinput($_POST['term_org'])."',
		term_to='".stripinput($_POST['term_to'])."',
		term_ratings='".(isNum($_POST['term_ratings']) ? $_POST['term_ratings'] : "0")."',
		term_type='".stripinput($_POST['term_type'])."',
		term_listdisplay='".stripinput($_POST['term_listdisplay'])."'
	");
	redirect(FUSION_SELF);
}

opentable($locale['term101']." - ".$locale['term601']);
echo term_toolbar();

echo "<form name='settingsform' method='post' action='".FUSION_SELF."'>";
echo "<table align='center' cellpadding='0' cellspacing='0' width='500'>";
if ($type != 0) {
	echo "<tr><td align='right' class='tbl'>".$locale['term602']."</td>";
	echo "<td class='tbl'><input type='hidden' name='term_version' value='".$dsettings['term_version']."' />\n";
	echo "<input type='text' name='term_org' value='".$dsettings['term_org']."' maxlength='200' class='textbox' style='width:200px;' /></td></tr>";
	echo "<tr><td align='center' colspan='2' class='tbl'><span class='small'>".$locale['term603']."</span></td></tr>";
	echo "<tr><td align='right' class='tbl'>".$locale['term604']."</td>";
	echo "<td class='tbl'><input type='text' name='term_to' value='".$dsettings['term_to']."' maxlength='200' class='textbox' style='width:200px;' /></td></tr>";
}
else {
	echo "<tr><td class='tbl' colspan='2'><input type='hidden' name='term_org' value='".$dsettings['term_org']."' maxlength='200' class='textbox' style='width:200px;' /></td></tr>";
	echo "<tr><td class='tbl' colspan='2'><input type='hidden' name='term_to' value='".$dsettings['term_to']."' maxlength='200' class='textbox' style='width:200px;' /></td></tr>";
}
echo "<tr><td align='right' class='tbl'>".$locale['term615']."</td>";
echo "<td class='tbl'><select name='term_listdisplay' class='textbox'>";
echo "<option value='1'".($dsettings['term_listdisplay'] == "1" ? " selected='selected'" : "").">".$locale['term617']."</option>";
echo "<option value='0'".($dsettings['term_listdisplay'] == "0" ? " selected='selected'" : "").">".$locale['term616']."</option>";
echo "</select></td></tr>";

echo "<tr><td align='right' class='tbl'>".$locale['term607']."</td>";
echo "<td class='tbl'><select name='term_ratings' class='textbox'>";
echo "<option value='1'".($dsettings['term_ratings'] == "1" ? " selected='selected'" : "").">".$locale['term608']."</option>";
echo "<option value='0'".($dsettings['term_ratings'] == "0" ? " selected='selected'" : "").">".$locale['term609']."</option>";
echo "</select></td></tr>"; 

echo "<tr><td align='right' class='tbl'>".$locale['term613'].": </td>";
echo "<td class='tbl'><select name='term_type' class='textbox'>";
echo "<option value='2'".($dsettings['term_type'] == "2" ? " selected='selected'" : "").">".$locale['term104']."</option>";
echo "<option value='1'".($dsettings['term_type'] == "1" ? " selected='selected'" : "").">".$locale['term105']."</option>";
echo "<option value='0'".($dsettings['term_type'] == "0" ? " selected='selected'" : "").">".$locale['term106']."</option>";
echo "</select></td></tr>";
echo "<tr><td align='center' colspan='2' class='tbl'><span class='small'>".$locale['term612']."</span></td></tr>";
echo "<tr><td align='center' colspan='2' class='tbl'><br />";
echo "<input type='submit' name='savesettings' value='".$locale['term606']."' class='button' />&nbsp;";
echo "<input type='submit' class='button' name='list' value='".$locale['term614']."' />";
echo "</td></tr></table></form>\n";
closetable();

require_once THEMES."templates/footer.php";
?>