<?php
/*---------------------------------------------------+
| PHP-Fusion 7 Content Management System
| Copyright  2002 - 2009 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Filename: terms_cats.php
| Author: Paul Beuk (muscapaul)
| Terms Infusion (Dictionary/Glossary)
| muscapaul@gmail.com / http://www.muscapaul.com
| Copyright  2008-2009
+----------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+----------------------------------------------------*/

require_once "../../maincore.php";
if (iADMIN) { 
	require_once THEMES."templates/admin_header.php";
}
else {
	require_once THEMES."templates/header.php";
}

include INFUSIONS."terms/infusion_db.php";

$dsettings = dbarray(dbquery("SELECT * FROM ".DB_TERM_SETTINGS.""));
$type = $dsettings['term_type'];

if (isset($_POST['cat_id']) || isset($_GET['cat_id'])) {
	$cat_id = (isset($_GET['cat_id']) ? $_GET['cat_id'] : $_POST['cat_id']);
	if (!isnum($cat_id)) { redirect(INFUSIONS."terms/terms.php"); }
} else { $cat_id = ""; }

$step = isset($_REQUEST['step']) ? $_REQUEST['step'] : "";

if (iADMIN || checkrights("TER")) {

if (file_exists(INFUSIONS."terms/".$type."locale/".$settings['locale'].".php")) {
	include INFUSIONS."terms/".$type."locale/".$settings['locale'].".php";
} else { include INFUSIONS."terms/".$type."locale/English.php"; }

require_once INFUSIONS."terms/include/functions.php";

if (isset($step) && $step == "delete") {
	$result = dbquery("SELECT * FROM ".DB_TERMS." WHERE term_cat='$cat_id'");
	if (dbrows($result) != 0) {
		opentable($locale['term401']);
		echo "<center><br />".$locale['term402']."<br />\n";
		echo "<span class='small'>".$locale['term403']."</span><br /><br />\n";
		echo "<a href='terms_admin.php'>".$locale['term404']."</a><br /><br />\n";
		echo "<a href='".BASEDIR."index.php'>".$locale['term405']."</a><br /><br />\n";
		echo "</center>\n";
	} else {
		$result = dbquery("DELETE FROM ".DB_TERM_CATS." WHERE term_cat_id='$cat_id'");
		opentable($locale['term406']);
		echo "<center><br />".$locale['term406']."<br /><br />\n";
		echo "<a href='".FUSION_SELF."'>".$locale['term404']."</a><br /><br />\n";
		echo "<a href='".BASEDIR."index.php'>".$locale['term405']."</a><br /><br />\n";
		echo "</center>\n";
	}
	closetable();
} else {
	if (isset($_POST['list'])) {
		fallback(INFUSIONS."terms/terms.php");
	}
	if (isset($_POST['save_cat'])) {
		$cat_name = stripinput($_POST['cat_name']);
		$cat_description = stripinput($_POST['cat_description']);
		$cat_access = isNum($_POST['cat_access']) ? $_POST['cat_access'] : "0";
		if (isset($step) && $step == "edit") {
			$result = dbquery("UPDATE ".DB_TERM_CATS." SET term_cat_name='$cat_name', term_cat_description='$cat_description', term_cat_access='$cat_access' WHERE term_cat_id='$cat_id'");
		}
		else {
			$result = dbquery("INSERT INTO ".DB_TERM_CATS." VALUES('', '$cat_name', '$cat_description', '$cat_access')");
		}
	redirect(INFUSIONS."terms/terms_cats.php");
//	header("Location: terms_cats.php");
	}
	if (isset($step) && $step == "edit") {
		$result = dbquery("SELECT * FROM ".DB_TERM_CATS." WHERE term_cat_id='$cat_id'");
		$data = dbarray($result);
		$cat_name = $data['term_cat_name'];
		$cat_description = $data['term_cat_description'];
		$cat_access = $data['term_cat_access'];
		$formaction = FUSION_SELF."?step=edit&amp;cat_id=".$data['term_cat_id'];
		opentable($locale['term421']);
	}
	else {
		$cat_name = "";
		$cat_description = "";
		$cat_access = "";
		$formaction = FUSION_SELF;
		opentable($locale['term422']);
	}
	$user_groups = getusergroups(); $access_opts = ""; $sel = "";
	while(list($key, $user_group) = each($user_groups)){
		$sel = ($cat_access == $user_group['0'] ? " selected='selected'" : "");
		$access_opts .= "<option value='".$user_group['0']."'$sel>".$user_group['1']."</option>\n";
	}
	echo "<center><table border='0' cellpadding='0' cellspacing='1' width='480'>\n";;
	echo "<tr><td align='center' width='100%'>",term_toolbar(),"</td></tr>\n";
	echo "</table></center>\n";

	echo "<div style='margin:5px'></div>\n";
	echo "<form name='addcat' method='post' action='$formaction'>\n";
	echo "<center><table width='480' cellspacing='0' cellpadding='0' border='0'>\n";
	echo "<tr><td class='tbl' style='whitespace:nowrap'>".$locale['term431']."</td>\n";
	echo "<td class='tbl'><input type='text' name='cat_name' value='$cat_name' class='textbox' style='width:200px;' /></td></tr>\n";
	echo "<tr><td class='tbl' style='whitespace:nowrap'>".$locale['term432']."</td>\n";
	echo "<td class='tbl'><input type='text' name='cat_description' value='$cat_description' class='textbox' style='width:250px;' /></td></tr>\n";
	echo "<tr><td class='tbl' style='whitespace:nowrap'>".$locale['term434']."</td>\n";
	echo "<td class='tbl'><select name='cat_access' class='textbox' style='width:150px;'>".$access_opts."</select></td></tr>\n";
	echo "<tr><td align='center' colspan='2' class='tbl'><input type='submit' name='save_cat' value='".$locale['term433']."' class='button' />&nbsp;<input type='submit' class='button' name='list' value='".$locale['term614']."' /></td></tr>\n";
	echo "</table></center>\n";
	echo "</form>\n";
	closetable();

	echo "<div style='margin:5px'></div>\n";
	opentable($locale['term441']);
	echo "<center><table width='480'><tr><td class='tbl2'><table width='100%' cellspacing='1' cellpadding='0' border='0'>\n";
	$result = dbquery("SELECT * FROM ".DB_TERM_CATS." ORDER BY term_cat_name");
	if (dbrows($result) != 0) {
		echo "<tr><td class='tbl1'>".$locale['term442']."</td>\n";
		echo "<td align='center' class='tbl1'>".$locale['term446']."</td>\n";
		echo "<td align='center' width='60' class='tbl1'>".$locale['term443']."</td>\n";
		echo "</tr>\n";
		while ($data = dbarray($result)) {
			echo "<tr><td class='tbl1'>".THEME_BULLET."&nbsp;<a href='".FUSION_SELF."?step=edit&amp;cat_id=".$data['term_cat_id']."'>".$data['term_cat_name']."</a><br />\n";
			echo "<span class='small'>".trimlink($data['term_cat_description'], 45)."</span></td>\n";
			echo "<td align='center' class='tbl1'>".getgroupname($data['term_cat_access'])."</td>\n";
			echo "<td align='center' class='tbl1'><a href='".FUSION_SELF."?step=edit&amp;cat_id=".$data['term_cat_id']."'><img src='".INFUSIONS."terms/images/edit.gif' border='0' title='".$locale['term447']."' alt='".$locale['term447']."' /></a>&nbsp;<a href='".FUSION_SELF."?step=delete&amp;cat_id=".$data['term_cat_id']."' onclick='return DeleteItem()'><img src='".INFUSIONS."terms/images/delete.gif' border='0' title='".$locale['term444']."' alt='".$locale['term444']."' /></a></td></tr>\n";
		}
		echo "</table></td></tr></table></center>\n";
		echo "<script type='text/javascript'>function DeleteItem() { return confirm('".$locale['term448']."'); } </script>\n";
		}
		else {
			echo "<tr><td align='center' class='tbl1'>".$locale['term445']."</td></tr>\n</table>\n";
		}
		closetable();
	}
	require_once THEMES."templates/footer.php";
}
else {
	redirect(BASEDIR."index.php");
}
?>