<?
/*--------------------------------------------+
| PHP-Fusion 6 - Content Management System    |
|---------------------------------------------|
| author: Nick Jones (Digitanium)  2002-2007 |
| web: http://www.php-fusion.co.uk            |
| email: nick@php-fusion.co.uk                |
|---------------------------------------------|
| Extended Profile                            |
|---------------------------------------------|
| author: Ronald Iwema (Scor3p)  2002-2005   |
| web: http://www.php-fusion.co.uk            |
| email: sxqsxqsxq@hotmail.com                |
|---------------------------------------------|
| updates: muscapaul  2005-2007              |
| web: http://www.muscapaul.com               |
| email: muscapaul@gmail.com                  |
|---------------------------------------------|
| Released under the terms and conditions of  |
| the GNU General Public License (Version 2)  |
+--------------------------------------------*/
include "../../maincore.php";
include "../../subheader.php";
include LOCALE.LOCALESET."admin/main.php";
include ADMIN."navigation.php";

if (file_exists(INFUSIONS."extended_profile/locale/".$settings['locale'].".php")) {
	include_once INFUSIONS."extended_profile/locale/".$settings['locale'].".php";
} else {
	include_once INFUSIONS."extended_profile/locale/English.php";
}

if (!iSUPERADMIN) { header("Location:../index.php"); exit; }

// process
$error = "";

if (get(move)){
	$name = $_GET['name'];
	$from = $_GET['from'];
	if (!is_numeric($from)) header("Location:".$_SERVER['PHP_SELF']); // SQL Injection
	if ($_GET['move'] == "down") $to = $from+1;
	elseif ($_GET['move'] == "up") $to = $from-1;
	else header("Location:".$_SERVER['PHP_SELF']);
	switchFields($name, $from, $to);
}

if (post('save_new_prop'))
{
	$new_prop_name = strtolower(trim($_POST['prop_name']));
	$new_prop_title = trim($_POST['prop_title']);
	$new_prop_order = toNumber($_POST['prop_order']);
	
	if (empty($new_prop_name)) $error .= $locale['XPF_201'] . "<br />";
	if (empty($new_prop_title)) $error .= $locale['XPF_202'] . "<br />";
	if (prop_name_exists($new_prop_name)) $error .= $locale['XPF_203'] . "<br />";
	if (!is_name_valid($new_prop_name)) $error .= $locale['XPF_204'] . "<br />";
	
	if (empty($error)) 
	{
		// add it
		addField();
	}
}

if (post('save_edit_prop'))
{
	$new_prop_name = strtolower(trim($_POST['prop_name']));
	$new_prop_title = trim($_POST['prop_title']);
	$new_prop_order = $_POST['prop_order'];
	
	if (empty($new_prop_name)) $error .= $locale['XPF_201'] . "<br />";
	if (empty($new_prop_title)) $error .= $locale['XPF_202'] . "<br />";
	if (!is_name_valid($new_prop_name)) $error .= $locale['XPF_204'] . "<br />"; // do this check anyway to prevent ppl from fucking with it..
	
	if (empty($error)) 
	{
		// edit it
		editField();
	}
}

if (post('del_prop'))
{
	deleteField($_POST['prop_name']);
}

// populate order select
$order_select = "<select name='prop_order' class='textbox'>\n";
$order_select.= "<option value='1'>-- ".$locale['XPF_016']." --</option>\n";

// Current Fields
openTable ($locale['XPF_001']);
$q = "SELECT * FROM ".$db_prefix."extended_profile_props ORDER BY prop_order ASC";
$r = dbQuery($q);
if ($r && mysql_num_rows($r) > 0)
{
	$total_fields = mysql_num_rows($r);
	echo "<table align='left' cellspacing='0' cellpadding='0' class='tbl'><tr><td>";
	while ($obj = mysql_fetch_object($r))
	{
		echo "<form name='editform".$obj->prop_name."' method='post' action='".$_SERVER['PHP_SELF']."' >";
		echo "<table width='100%' align='left'><tr>";
		echo "<td width='15%'>".$obj->prop_name."&nbsp;&nbsp;</td>";
		echo "<td width='25%'>".htmlspecialchars($obj->prop_title, ENT_QUOTES)."&nbsp;&nbsp;</td>";
		echo "<td width='10' align='right'>&nbsp;[&nbsp;" . $obj->prop_order . "</td>";
		
		echo "<td width='20' valign='middle' align='right'>&nbsp;";
		if ($obj->prop_order != 1) echo "<a href='".$_SERVER['PHP_SELF']."?move=up&amp;name=".$obj->prop_name."&amp;from=".$obj->prop_order."'><img src='".THEME."images/up.gif' border='0' alt='Up' /></a>";
		echo "</td><td width='20' valign='middle'  align='left'>&nbsp;";
		if ($obj->prop_order != $total_fields) echo "<a href='".$_SERVER['PHP_SELF']."?move=down&amp;name=".$obj->prop_name."&amp;from=".$obj->prop_order."'><img src='".THEME."images/down.gif' border='0' alt='Down' /></a>";
		echo "</td><td width='10' align='left'>&nbsp;]&nbsp;</td>";
		echo "<td><input type='submit' name='edit_prop' value='".$locale['XPF_022']."' class='button' /> ";
		echo " <input type='submit' name='del_prop' value='".$locale['XPF_023']."' class='button' onClick='return DeleteField();' /> ";
		echo "<input type='hidden' name='prop_name' value='" . $obj->prop_name . "' /></td></tr>";
		echo "</table>\n</form>\n";
		
		if ($obj->prop_order != $total_fields)
			$order_select.= "<option value='".($obj->prop_order+1)."'>".$locale['XPF_015']." ".$obj->prop_name."</option>\n";
		else
			$order_select.= "<option value='".($obj->prop_order+1)."' selected>-- ".$locale['XPF_017']." --</option>\n";
		
	}
	echo "</td></tr></table>";
}
else 
{
	echo $locale['XPF_002'];
}
closeTable();
$order_select .= "</select>\n";


tableBreak();

if (post('edit_prop')) 
{
	openTable ($locale['XPF_021']);
	$q = "SELECT * FROM ".$db_prefix."extended_profile_props WHERE prop_name = '".$_POST['prop_name']."'";
	$r = dbquery($q);
	if ($r && mysql_num_rows($r) == 1)
	{
		$new_prop_name = mysql_result($r, 0, 'prop_name');
		$new_prop_title = mysql_result($r, 0, 'prop_title');
		$new_prop_order = mysql_result($r, 0, 'prop_order');
	}
	$submit = "<input type='submit' name='save_edit_prop' value='".$locale['XPF_021']."' class='button'>";
	$name = "<input type='text' name='prop_name' value='$new_prop_name' class='textbox' style='width:250px;' readonly> (<span class='small'>".$locale['XPF_040'].")</span>";
	$order_select = $new_prop_order;
}
else 
{
	openTable ($locale['XPF_010']);
	$submit = "<input type='submit' name='save_new_prop' value='".$locale['XPF_020']."' class='button'>";
	$name = "<input type='text' name='prop_name' value='$new_prop_name' class='textbox' style='width:250px;'> * ".$locale['XPF_012'];

}


if (!empty($error)) echo "<div class=\"quote\">" . $locale['XPF_200'] . "<hr />" . $error . "</div>";
echo "<form name='inputform' method='post' action='".$_SERVER['PHP_SELF']."' onSubmit='return ValidateForm(this)'>\n";
echo "<table align='center' cellspacing='0' cellpadding='0' class='tbl'>";
echo "<tr><td width='100'>".$locale['XPF_011']."</td><td>$name</td></tr>";
echo "<tr><td valign='top' width='100'><input type='hidden' name='prop_order' value='$new_prop_order'>".$locale['XPF_013']."</td>";
echo "<td><input type='text' name='prop_title' value='$new_prop_title' class='textbox' style='width:250px;'></td></tr>";
echo "<tr><td>".$locale['XPF_014']."</td><td>$order_select</td></tr>";
echo "<tr><td align='center' colspan='2'><br>$submit</td></tr>";
echo "</table>\n</form>\n";

// finally add some JavaScript

echo "<script type='text/javascript'>
function DeleteField() {
    return confirm('".$locale['XPF_030']."');
}
function ValidateForm(frm) {
    if(frm.prop_name.value=='') {
        alert('".$locale['XPF_205']."');
        return false;
    }
    if(frm.prop_title.value=='') {
        alert('".$locale['XPF_206']."');
        return false;
    }
    return true;
}
</script>\n";

closeTable();

/*
	echo "<pre>";
	print_r($_POST);
	echo "</pre>";
*/

include BASEDIR."footer.php";

function switchFields($name, $from, $to)
{ // switch 2 fields
	global $db_prefix;
	$q1 = "UPDATE ".$db_prefix."extended_profile_props SET prop_order=$from WHERE prop_order=$to";
	$q2 = "UPDATE ".$db_prefix."extended_profile_props SET prop_order=$to WHERE prop_name='" . htmlspecialchars($name) . "'";
	$r = dbquery($q1);
	$r = dbquery($q2);
}

function addField()
{ // add field
	global $db_prefix, $new_prop_name, $new_prop_title,	$new_prop_order;
	$q = "UPDATE ".$db_prefix."extended_profile_props SET prop_order = prop_order + 1 WHERE prop_order >= $new_prop_order";
	$r = dbquery($q);
	
	$q  = "	INSERT INTO ".$db_prefix."extended_profile_props (
			prop_name, 
			prop_title, 
			prop_order
			) VALUES (
			'".$new_prop_name."',
			'".addslashes($new_prop_title)."',
			'". $new_prop_order ."'
			)";
	$r = dbquery($q);
	$new_prop_name = $new_prop_title = $new_prop_order = "";
}

function editField()
{ // edit field
	global $db_prefix, $new_prop_name, $new_prop_title,	$new_prop_order;
	$q = "	UPDATE ".$db_prefix."extended_profile_props SET
			prop_title = '".addslashes($new_prop_title)."',
			prop_order = '". $new_prop_order ."'
			WHERE prop_name = '". $new_prop_name . "'";
	$r = dbquery($q);
	$new_prop_name = $new_prop_title = $new_prop_order = "";
}

function deleteField($name)
{ // delete field
	global $db_prefix;
	$q = "SELECT prop_order FROM ".$db_prefix."extended_profile_props WHERE prop_name='".addslashes($name)."'";
	$r = mysql_query($q);
	if ($r && mysql_num_rows($r) == 1){
		$old_prop_order = mysql_result($r, 0, 'prop_order');
		$result = dbquery("DELETE FROM ".$db_prefix."extended_profile_props WHERE prop_name='".addslashes($name)."'");
		$result = dbquery("UPDATE ".$db_prefix."extended_profile_props SET prop_order = prop_order - 1 WHERE prop_order >= $old_prop_order");
	}
}

function toNumber ($new_order)
{ // check input, if valid leave as new order remove leading zero's, else get highest order around
	global $db_prefix;
	if (preg_match("/^(0*)([1-9]{1}[0-9]*)$/", $new_order, $result)) return $result[2];
	$r = dbQuery("SELECT MAX(prop_order)+1 AS new_order FROM ".$db_prefix."extended_profile_props");
	if (!$r || mysql_num_rows($r) == 0 || mysql_result($r, 0, 'new_order') == 0) return 1;
	return mysql_result($r, 0, 'new_order');
}

function is_name_valid($new_prop_name)
{ // names should be alfanumeric, and lowercase, but script should do that
	return preg_match("/^[a-z0-9_]+$/", $new_prop_name);
}

function prop_name_exists($new_prop_name, $old_prop_name = "")
{ // checks if a name already exists, except when name is the same as the old name
	global $db_prefix;
	// when editing the old name could be unchanged, so the update is allowed, return false
	if ($new_prop_name == $old_prop_name) return false;
	// try to find the prop_name
	$r = dbQuery("SELECT prop_name FROM ".$db_prefix."extended_profile_props WHERE prop_name='".addslashes($new_prop_name)."'");
	// if there is no result for any reason it's safer to prevent futher db changed, return true
	if (!$r) return true;
	// no records found means the prop_name is not found, return true
	if (mysql_num_rows($r) == 0) return false;
	// so there is a record found, return true
	return true;
}

function post($var)
{ // check if a post var is set and has a value
	if (isset($_POST[$var]) && !empty($_POST[$var]))
		return true;
	return false;
}

function get($var)
{ // check if a get var is set and has a value
	if (isset($_GET[$var]) && !empty($_GET[$var]))
		return true;
	return false;
}
?>